const express = require("express");
const mongoose = require("mongoose");
const bodyParser = require("body-parser");
const cors = require("cors");

// Initialize the app
const app = express();
const PORT = 5000;

// Middleware
app.use(cors());
app.use(bodyParser.json());

// Connect to MongoDB
const mongoURI = "mongodb://localhost:27017/HighScores";
mongoose
  .connect(mongoURI, { useNewUrlParser: true, useUnifiedTopology: true })
  .then(() => console.log("Connected to MongoDB"))
  .catch((err) => console.error("Error connecting to MongoDB:", err));

// Define Schema and Model
const highScoreSchema = new mongoose.Schema({
  username: String,
  score: Number,
});

const HighScore = mongoose.model("HighScore", highScoreSchema);

// API Endpoints
app.post("/highscores", async (req, res) => {
  try {
    const { username, score } = req.body;
    const newHighScore = new HighScore({ username, score });
    await newHighScore.save();
    res.status(201).json({ message: "High score saved successfully!" });
  } catch (err) {
    console.error(err);
    res.status(500).json({ error: "Failed to save high score." });
  }
});

app.get("/highscores", async (req, res) => {
  try {
    const highScores = await HighScore.find().sort({ score: 1 });
    res.status(200).json(highScores);
  } catch (err) {
    console.error(err);
    res.status(500).json({ error: "Failed to fetch high scores." });
  }
});

// Start the server
app.listen(PORT, () => {
  console.log(`Server running on http://localhost:${PORT}`);
});
